# getDirectoryToWatchFailedLookupLocationInsubDirNonRecursive

Determines whether to watch given failed lookup location (file that didnt exist) when resolving module.
It also determines the directory to watch and whether to watch it recursively or not.

## Testing for Dos root: c:/

## RootDirForResolution: c:/

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir                                                                    | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2                                                                | true      |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir                                                            | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3                                                        | true      |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir                                                    | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4                                                | true      |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir                                            | true      |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5                                        | true      |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                                    | true      |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/users

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/users/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir                                                     | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2                                                 | true      |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir                                             | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3                                         | true      |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir                                     | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4                                 | true      |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                             | true      |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                         | true      |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                     | true      |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/user

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/user/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir                                                                           | true      |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir                                                              | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/usr

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/usr/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir                                                                            | true      |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot                                                                   | true      |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir                                                               | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1                                                           | true      |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir                                                       | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2                                                   | true      |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir                                               | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3                                           | true      |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir                                       | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4                                   | true      |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                               | true      |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                           | true      |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                       | true      |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/home

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/home/username

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir                                                                           | true      |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot                                                                  | true      |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir                                                              | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1                                                          | true      |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir                                                      | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2                                                  | true      |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir                                              | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3                                          | true      |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir                                      | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4                                  | true      |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir                              | true      |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5                          | true      |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                      | true      |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/workspaces

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                  | false     |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir                                                                 | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1                                                             | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir                                                         | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2                                                     | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir                                                 | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3                                             | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2/folder3

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir                                         | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4                                     | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir                                 | true      |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5                             | true      |                                                                                                |

## RootDirForResolution: c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5

| Location                                                                                       | getDirectoryToWatchFailedLookupLocation                                                        | Recursive | Location if not symlink                                                                        |
| ---------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------- | --------- | ---------------------------------------------------------------------------------------------- |
| c:/dir/subdir/somefile.d.ts                                                                    | c:/dir/subdir                                                                                  | false     |                                                                                                |
| c:/folderAtRoot/dir/subdir/somefile.d.ts                                                       | c:/folderAtRoot/dir/subdir                                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                               | c:/folderAtRoot/folder1/dir/subdir                                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                                       | c:/folderAtRoot/folder1/folder2/dir/subdir                                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                               | c:/folderAtRoot/folder1/folder2/folder3/dir/subdir                                             | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts                       | c:/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                                     | false     |                                                                                                |
| c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts               | c:/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                             | false     |                                                                                                |
| c:/users/dir/subdir/somefile.d.ts                                                              | c:/users/dir/subdir                                                                            | false     |                                                                                                |
| c:/users/username/dir/subdir/somefile.d.ts                                                     | c:/users/username/dir/subdir                                                                   | false     |                                                                                                |
| c:/users/username/folderAtRoot/dir/subdir/somefile.d.ts                                        | c:/users/username/folderAtRoot/dir/subdir                                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                | c:/users/username/folderAtRoot/folder1/dir/subdir                                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                        | c:/users/username/folderAtRoot/folder1/folder2/dir/subdir                                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                | c:/users/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                              | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts        | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                      | false     |                                                                                                |
| c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/users/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir              | false     |                                                                                                |
| c:/user/dir/subdir/somefile.d.ts                                                               | c:/user/dir/subdir                                                                             | false     |                                                                                                |
| c:/user/username/dir/subdir/somefile.d.ts                                                      | c:/user/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/user/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/user/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/user/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/user/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/user/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/user/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/usr/dir/subdir/somefile.d.ts                                                                | c:/usr/dir/subdir                                                                              | false     |                                                                                                |
| c:/usr/username/dir/subdir/somefile.d.ts                                                       | c:/usr/username/dir/subdir                                                                     | false     |                                                                                                |
| c:/usr/username/folderAtRoot/dir/subdir/somefile.d.ts                                          | c:/usr/username/folderAtRoot/dir/subdir                                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                  | c:/usr/username/folderAtRoot/folder1/dir/subdir                                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                          | c:/usr/username/folderAtRoot/folder1/folder2/dir/subdir                                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                                | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts          | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                        | false     |                                                                                                |
| c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts  | c:/usr/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir                | false     |                                                                                                |
| c:/home/dir/subdir/somefile.d.ts                                                               | c:/home/dir/subdir                                                                             | false     |                                                                                                |
| c:/home/username/dir/subdir/somefile.d.ts                                                      | c:/home/username/dir/subdir                                                                    | false     |                                                                                                |
| c:/home/username/folderAtRoot/dir/subdir/somefile.d.ts                                         | c:/home/username/folderAtRoot/dir/subdir                                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                 | c:/home/username/folderAtRoot/folder1/dir/subdir                                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                         | c:/home/username/folderAtRoot/folder1/folder2/dir/subdir                                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                 | c:/home/username/folderAtRoot/folder1/folder2/folder3/dir/subdir                               | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts         | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                       | false     |                                                                                                |
| c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts | c:/home/username/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir               | false     |                                                                                                |
| c:/workspaces/dir/subdir/somefile.d.ts                                                         | c:/workspaces/dir/subdir                                                                       | false     |                                                                                                |
| c:/workspaces/folderAtRoot/dir/subdir/somefile.d.ts                                            | c:/workspaces/folderAtRoot/dir/subdir                                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/dir/subdir/somefile.d.ts                                    | c:/workspaces/folderAtRoot/folder1/dir/subdir                                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir/somefile.d.ts                            | c:/workspaces/folderAtRoot/folder1/folder2/dir/subdir                                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir/somefile.d.ts                    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/dir/subdir                                  | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir/somefile.d.ts            | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/dir/subdir                          | false     |                                                                                                |
| c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir/subdir/somefile.d.ts    | c:/workspaces/folderAtRoot/folder1/folder2/folder3/folder4/folder5/dir                         | true      |                                                                                                |

